// ===== VEXIRO CORE ENGINE =====

const Vexiro = {
    isShizukuAvailable: false,
    actionRegistry: {},
    
    init: function() {
        setInterval(() => this.checkShizuku(), 8000);
        
        const saved = localStorage.getItem('vex_command');
        if (saved && document.getElementById('codeEditor')) {
            document.getElementById('codeEditor').value = saved;
        }
        
       const editor = document.getElementById('codeEditor');
        if (editor) {
            editor.addEventListener('input', () => {
                localStorage.setItem('vex_command', editor.value);
            });
        }
        
        this.checkShizuku();
    },
    
      registerAction: function(actionName, commandString) {
        this.actionRegistry[actionName] = commandString;
    },
    
    runAction: function(actionName) {
        if (!this.isShizukuAvailable) {
            return;
        }
        
        if (!this.actionRegistry[actionName]) {
            return;
        }
        
        this.executeCommand(this.actionRegistry[actionName]);
    },
    
    checkShizuku: function() {
        if (typeof shizuku !== 'undefined' && shizuku !== null) {
            this.isShizukuAvailable = true;
            return true;
        } else {
            this.isShizukuAvailable = false;
            return false;
        }
    },
    
    executeCommand: function(command) {
        if (!this.isShizukuAvailable) {
            return;
        }
        
        const callbackId = 'vex_' + Date.now();
        
        window[callbackId] = (errno, stdout, stderr) => {
            delete window[callbackId];
            
        };
        
        try {
            shizuku.shellExec(command, JSON.stringify({cwd: "/system"}), callbackId);
        } catch (error) {
            
        }
    },
    
    runCustomCommand: function() {
        const editor = document.getElementById('codeEditor');
        if (!editor) return;
        
        const command = editor.value.trim();
        if (!command) {
            return;
        }
        
        this.executeCommand(command);
    },
    
    clearEditor: function() {
        const editor = document.getElementById('codeEditor');
        if (!editor) return;
        
        editor.value = '# Masukkan shell commands Anda di sini\n' +
                       '# Format bebas - persis seperti di terminal\n\n' +
                       '# Contoh:\n' +
                       'echo "Hello Vexiro"\n' +
                       'sleep 1\n' +
                       'settings put global window_animation_scale 0.5\n' +
                       '\n' +
                       '# Bisa juga pakai script panjang:\n' +
                       'echo "█▓▒▒░░░ Memulai... ░░░▒▒▓█"\n' +
                       'date\n' +
                       'uname -a';
        
        localStorage.setItem('vex_command', editor.value);
    }
};